#!/usr/bin/env python3
# coding: utf-8

import importlib
import tkinter as tk
from tkinter import font
from tkinter import filedialog

pyv2d_version = "21.10-6"

#ロゴ表示
title_win = tk.Tk()

title_win.overrideredirect(True)

desktop_x = title_win.winfo_screenwidth()
desktop_y = title_win.winfo_screenheight()

if desktop_x / desktop_y > 3.5:
    desktop_x /= 2

title_win.geometry("640x320+" + str(int(desktop_x / 2 - 320)) + "+" + str(int(desktop_y / 2 -160)))

slash_pos = __file__.rfind("/")
if slash_pos == -1:
    slash_pos = __file__.rfind("\\")
logo = tk.PhotoImage(file=__file__[0:slash_pos] + "/files/pyv2d_logo.png")

title_canv = tk.Canvas(title_win, width=640, height=320, bg="#222222", highlightthickness=0)
title_canv.place(x=0, y=0, anchor=tk.NW)
title_canv.create_image(320, 160, image=logo, anchor=tk.CENTER)

v_font = tk.font.Font(size=14)
v_label = tk.Label(title_win, text="Version " + pyv2d_version, font=v_font, fg="#444444", bg="#222222")
v_label.place(x=460, y=280)

load_ok = True
error_mes = ""


#各種初期化処理
def pyv2d_init ():
    global title_win
    global os
    global json
    global np
    global sd
    global keyboard
    global is_linux
    global config
    global sd_stream

    
    #モジュール読み込み
    os = importlib.import_module("os")
    json = importlib.import_module("json")
    platform = importlib.import_module("platform")
    
    this_dir = os.path.dirname(os.path.abspath(__file__))
    os.chdir(this_dir)
    
    if platform.system() == "Linux":
        is_linux = True
    else:
        is_linux = False
    
    try:
        np = importlib.import_module("numpy")
        sd = importlib.import_module("sounddevice")
        if not is_linux:
            keyboard = importlib.import_module("keyboard")
    except:
        set_error("動作環境が正しくインストールされていません", True)
    else:
        #マイク入力ストリーム初期化
        try:
            sd_stream = sd.InputStream(channels=1)
        except:
            set_error("マイクからの音声取得が実行できません", True)
    
    #設定ファイル読み込み
    try:
        json_fp = open("files/config.json", "r", encoding="utf-8")
        config = json.load(json_fp)
    except:
        set_error("設定ファイルが破損し、データが初期化されました", False)
        json_fp2 = open("files/default_config.json", "r", encoding="utf-8")
        config = json.load(json_fp2)
    
    title_win.destroy()

#エラー情報記録処理
def set_error (mes, is_critical):
    global load_ok
    global error_mes
    
    if is_critical and load_ok:
        load_ok = False
        error_mes = mes


#初期化処理実行
title_win.after(1000, pyv2d_init)
title_win.mainloop()


#アバターウインドウを開いて初期化する処理
def open_main_window (delete_mes = True):
    global pyv2d_version
    global main_window_opened
    global win
    global cont_win
    global avatar
    global canv
    global config
    global base_image
    global eyes
    global eyes_close
    global mouth_open
    global mouth_close
    global hotkey_list
    global special_faces
    global cont_chk_bool
    global avatar_dir_label
    global special_face_number
    global cur_mouth
    global last_volume
    
    if main_window_opened or not load_ok:
        return
    
    main_window_opened = True
    
    try:
        json_fp_2 = open(config["avatar_dir"] + "/avatar.json", "r", encoding="utf-8")
        avatar = json.load(json_fp_2)
    except:
        show_message("指定されたアバター設定ファイルが読み込めません", True)
        main_window_opened = False
        avatar_dir_label["fg"] = "#ff0077"
        return
    
    win = tk.Toplevel()
    win.title("PyV2D")
    win.geometry(str(avatar["width"]) + "x" + str(avatar["height"]) + "+" + str(config["main_window"]["rootx"]) + "+" + str(config["main_window"]["rooty"]))
    win.resizable(0, 0)
    
    canv = tk.Canvas(win, bg=config["background_color"], width=avatar["width"], height=avatar["height"], highlightthickness=0)
    canv.place(x=0, y=0, anchor=tk.NW)
    
    cont_win = tk.Toplevel()
    cont_win.title("PyV2D 表情切り替え")
    cont_win.geometry("240x480+" + str(config["controller_window"]["rootx"]) + "+" + str(config["controller_window"]["rooty"]))
    cont_win.resizable(0, 0)
    cont_win.configure(bg="#222222")
    
    cont_chk_bool = tk.BooleanVar(value=config["controller_foreground"])
    cont_chk = tk.Checkbutton(cont_win, variable=cont_chk_bool, text="このウインドウを最前面に表示", bg="#222222", activebackground="#222222", fg="#ffffff", activeforeground="#ffffff", highlightbackground="#222222", selectcolor="#444444", command=cont_chk_on_change)
    cont_chk.place(x=5, y=5)
    if config["controller_foreground"]:
        cont_win.attributes("-topmost", True)
    
    try:
        base_image = tk.PhotoImage(file=config["avatar_dir"] + "/" + avatar["base"])
        canv.create_image(0, 0, image=base_image, anchor=tk.NW, tag="base")
        
        eyes = tk.PhotoImage(file=config["avatar_dir"] + "/" + avatar["opened_eyes"])
        eyes_close = tk.PhotoImage(file=config["avatar_dir"] + "/" + avatar["closed_eyes"])
        mouth_close = tk.PhotoImage(file=config["avatar_dir"] + "/" + avatar["closed_mouth"])
        mouth_open = []
        for mouth_image in avatar["opened_mouth"]:
            mouth_open.append(tk.PhotoImage(file=config["avatar_dir"] + "/" + mouth_image))
        
        if not is_linux:
            hotkey_list = []
        special_faces = []
        for cnt in range(len(avatar["special_faces"])):
            add_face(cnt)
    except:
        show_message("アバター画像の読み込みに失敗しました", True)
        win.destroy()
        cont_win.destroy()
        main_window_opened = False
        return
    
    if not is_linux:
        win.iconbitmap("files/pyv2d.ico")
        cont_win.iconbitmap("files/pyv2d.ico")
    win.protocol("WM_DELETE_WINDOW", main_window_close)
    cont_win.protocol("WM_DELETE_WINDOW", main_window_close)
    
    special_face_number = -1
    cur_mouth = -1
    last_volume = 0
    move_mouth()
    omeme_pachi(False)
    
    if delete_mes:
        show_message("PyV2D " + pyv2d_version, False)

#表情データを1件読み込む処理
def add_face (num):
    global config
    global avatar
    global cont_win
    global hotkey_list
    global mouth_close
    global button_font
    
    face_images = {}
    
    if not avatar["special_faces"][num]["base"]:
        face_images["base"] = None
    else:
        face_images["base"] = tk.PhotoImage(file=config["avatar_dir"] + "/" + avatar["special_faces"][num]["base"])
    
    if not avatar["special_faces"][num]["closed_eyes"]:
        face_images["closed_eyes"] = None
    else:
        face_images["closed_eyes"] = tk.PhotoImage(file=config["avatar_dir"] + "/" + avatar["special_faces"][num]["closed_eyes"])
    
    if not avatar["special_faces"][num]["opened_eyes"]:
        face_images["opened_eyes"] = None
    else:
        face_images["opened_eyes"] = tk.PhotoImage(file=config["avatar_dir"] + "/" + avatar["special_faces"][num]["opened_eyes"])
    
    if not avatar["special_faces"][num]["closed_mouth"]:
        face_images["closed_mouth"] = None
    else:
        face_images["closed_mouth"] = tk.PhotoImage(file=config["avatar_dir"] + "/" + avatar["special_faces"][num]["closed_mouth"])
    
    if not avatar["special_faces"][num]["opened_mouth"]:
        face_images["opened_mouth"] = None
    else:
        face_images["opened_mouth"] = []
        for mouth_image in avatar["special_faces"][num]["opened_mouth"]:
            face_images["opened_mouth"].append(tk.PhotoImage(file=config["avatar_dir"] + "/" + mouth_image))
    
    special_faces.append(face_images)
    
    if not avatar["special_faces"][num]["key"]:
        key_text = ""
    else:
        key_text = "(" + avatar["special_faces"][num]["key"] + ")"
    
    cont_button = tk.Button(cont_win, text=avatar["special_faces"][num]["text"] + key_text, font=button_font, command=lambda: special_face(num), bg="#444444", fg="#ffffff", relief="flat", highlightbackground="#444444", width=24)
    cont_button.place(x=120, y=60+45*num, anchor=tk.CENTER)
    
    if is_linux or not avatar["special_faces"][num]["key"]:
        return
    
    hotkey_list.append(keyboard.add_hotkey(avatar["special_faces"][num]["key"], lambda: special_face(num)))

#アバターウインドウを閉じる処理
def main_window_close ():
    global win
    global cont_win
    global config
    global main_window_opened
    global rootx_correction
    global rooty_correction
    global job_id_pachi
    global job_id_mouth
    global hotkey_list
    
    menu_win.after_cancel(job_id_pachi)
    menu_win.after_cancel(job_id_mouth)
    
    if not is_linux:
        for hotkey in hotkey_list:
            keyboard.remove_hotkey(hotkey)
    
    config["main_window"]["rootx"] = win.winfo_rootx() - rootx_correction
    config["main_window"]["rooty"] = win.winfo_rooty() - rooty_correction
    
    config["controller_window"]["rootx"] = cont_win.winfo_rootx() - rootx_correction
    config["controller_window"]["rooty"] = cont_win.winfo_rooty() - rooty_correction
    
    win.destroy()
    cont_win.destroy()
    main_window_opened = False

#メニューウインドウとその他全てのウインドウを閉じる処理
def menu_window_close ():
    global menu_win
    global win
    global config
    global main_window_opened
    global rootx_correction
    global rooty_correction
    
    config["menu_window"]["rootx"] = menu_win.winfo_rootx() - rootx_correction
    config["menu_window"]["rooty"] = menu_win.winfo_rooty() - rooty_correction
    if main_window_opened:
        main_window_close()
    
    menu_win.destroy()


#メニューウインドウ上部文字列更新処理
def show_message (mes, iserror = False):
    global mes_label
    
    if iserror:
        mes_label["fg"] = "#ff0077"
        mes_label["text"] = "[ ERROR ]\n" + mes
    else:
        mes_label["fg"] = "#00cc71"
        mes_label["text"] = mes


#音量に応じた口の開閉処理
def move_mouth ():
    global config
    global canv
    global mouth_open
    global mouth_close
    global special_faces
    global special_face_number
    global cur_mouth
    global sd_stream
    global special_faces
    global special_face_number
    global last_volume
    global main_window_opened
    global job_id_mouth
    
    if not main_window_opened:
        return
    
    if special_face_number == -1 or special_faces[special_face_number]["closed_mouth"] is None or special_faces[special_face_number]["opened_mouth"] is not None:
        if special_face_number == -1 or special_faces[special_face_number]["opened_mouth"] is None:
            mouth_images = mouth_open
        else:
            mouth_images = special_faces[special_face_number]["opened_mouth"]
        
        rev_cnt = len(mouth_images)
        threshold_step = config["volume_threshold"] / rev_cnt
        
        sd_stream.start()
        volume = np.linalg.norm(sd_stream.read(1)[0]) * 100
        sd_stream.stop()
        
        last_volume = last_volume - config["volume_threshold"] / 4
        if last_volume > volume:
            volume = last_volume
        elif volume > config["volume_threshold"] * 2:
            last_volume = config["volume_threshold"] * 2
        else:
            last_volume = volume
        
        for mouth_image in reversed(mouth_images):
            if volume > threshold_step * rev_cnt:
                if rev_cnt != cur_mouth:
                    if cur_mouth != -1:
                        canv.delete("mouth")
                    canv.create_image(0, 0, image=mouth_image, anchor=tk.NW, tag="mouth")
                    cur_mouth = rev_cnt
                break
            rev_cnt -= 1
        
        if cur_mouth != 0 and rev_cnt == 0:
            if cur_mouth != -1:
                canv.delete("mouth")
            
            if special_face_number == -1 or special_faces[special_face_number]["closed_mouth"] is None:
                canv.create_image(0, 0, image=mouth_close, anchor=tk.NW, tag="mouth")
            else:
                canv.create_image(0, 0, image=special_faces[special_face_number]["closed_mouth"], anchor=tk.NW, tag="mouth")
            
            cur_mouth = rev_cnt
    
    job_id_mouth = menu_win.after(30, move_mouth)

#まばたきで目を閉じる処理
def omeme_pachipachi ():
    global canv
    global eyes_close
    global job_id_pachi
    global special_faces
    global special_face_number
    
    if not main_window_opened:
        return
    
    if special_face_number == -1 or special_faces[special_face_number]["closed_eyes"] is not None:
        canv.delete("eyes")
        
        if special_face_number == -1:
            canv.create_image(0, 0, image=eyes_close, anchor=tk.NW, tag="eyes")
        else:
            canv.create_image(0, 0, image=special_faces[special_face_number]["closed_eyes"], anchor=tk.NW, tag="eyes")
    
    job_id_pachi = menu_win.after(100, omeme_pachi)

#まばたきで目を開く処理
def omeme_pachi (delete_eyes_close = True):
    global canv
    global eyes
    global job_id_pachi
    global special_faces
    global special_face_number
    
    if not main_window_opened:
        return
    
    if special_face_number == -1 or special_faces[special_face_number]["closed_eyes"] is not None:
        if delete_eyes_close:
            canv.delete("eyes")
        
        if special_face_number == -1 or special_faces[special_face_number]["opened_eyes"] is None:
            canv.create_image(0, 0, image=eyes, anchor=tk.NW, tag="eyes")
        else:
            canv.create_image(0, 0, image=special_faces[special_face_number]["opened_eyes"], anchor=tk.NW, tag="eyes")
    
    next_pachi = np.random.normal(loc=4000, scale=200)
    if next_pachi < 1000:
        next_pachi = 1000
    job_id_pachi = menu_win.after(int(next_pachi), omeme_pachipachi)

#表情を切り替える処理
def special_face (num):
    global canv
    global special_face_number
    global base_image
    global eyes
    global special_faces
    global cur_mouth
    
    if not main_window_opened:
        return
    
    if num == special_face_number:
        if special_faces[num]["base"] is not None:
            canv.delete("base")
            canv.create_image(0, 0, image=base_image, anchor=tk.NW, tag="base")
        
        if special_faces[num]["opened_eyes"] is not None:
            canv.delete("eyes")
            canv.create_image(0, 0, image=eyes, anchor=tk.NW, tag="eyes")
            
        if special_faces[num]["closed_mouth"] is not None or special_faces[special_face_number]["opened_mouth"] is not None:
            canv.delete("mouth")
            canv.create_image(0, 0, image=mouth_close, anchor=tk.NW, tag="mouth")
            cur_mouth = 0
        
        special_face_number = -1
    else:
        if special_faces[num]["base"] is not None:
            canv.delete("base")
            canv.create_image(0, 0, image=special_faces[num]["base"], anchor=tk.NW, tag="base")
        elif special_face_number != -1 and special_faces[special_face_number]["base"] is not None:
            canv.delete("base")
            canv.create_image(0, 0, image=base_image, anchor=tk.NW, tag="base")
        
        if special_faces[num]["opened_eyes"] is not None:
            canv.delete("eyes")
            canv.create_image(0, 0, image=special_faces[num]["opened_eyes"], anchor=tk.NW, tag="eyes")
        elif special_face_number != -1 and special_faces[special_face_number]["opened_eyes"] is not None:
            canv.delete("eyes")
            canv.create_image(0, 0, image=eyes, anchor=tk.NW, tag="eyes")
            
        if special_faces[num]["closed_mouth"] is not None:
            canv.delete("mouth")
            canv.create_image(0, 0, image=special_faces[num]["closed_mouth"], anchor=tk.NW, tag="mouth")
            cur_mouth = 0
        elif special_face_number != -1 and (special_faces[special_face_number]["closed_mouth"] is not None or special_faces[special_face_number]["opened_mouth"] is not None):
            canv.delete("mouth")
            canv.create_image(0, 0, image=mouth_close, anchor=tk.NW, tag="mouth")
            cur_mouth = 0
        
        special_face_number = num
    
    canv.lower("base")

#表情コントローラウインドウの最前面表示を切り替える処理
def cont_chk_on_change () :
    global config
    global cont_win
    global cont_chk_bool
    
    if cont_chk_bool.get():
        config["controller_foreground"] = True
        cont_win.attributes("-topmost", True)
    else:
        config["controller_foreground"] = False
        cont_win.attributes("-topmost", False)


#口を開閉させる音量を設定する処理
def update_volume_threshold ():
    global config
    global input_1
    
    input_val = input_1.get()
    
    try:
        config["volume_threshold"] = float(input_val)
        
        show_message("検知音量を " + str(config["volume_threshold"]) + "% に変更しました")
    except:
        show_message("入力内容に誤りがあります", True)

#アバターウインドウの背景色を指定する処理
def set_bgcolor (color, color_text):
    global menu_win
    global config
    
    config["background_color"] = color
    
    show_message("背景色を " + color_text + " に変更しました")
    
    if not main_window_opened:
        return
    
    main_window_close()
    menu_win.after(500, lambda: open_main_window(False))

#アバターデータフォルダを指定する処理
def change_avatar_dir ():
    global config
    global avatar_dir_label
    
    config["avatar_dir"] = os.path.relpath(filedialog.askdirectory(title="アバターデータのフォルダを選択してください"))
    
    avatar_dir_label["text"] = config["avatar_dir"]
    
    avatar_dir_label["fg"] = "#cccccc"
    
    if not main_window_opened:
        return
    
    main_window_close()
    menu_win.after(500, lambda: open_main_window(False))


#メニューウインドウ表示処理
menu_win = tk.Tk()
if is_linux:
    menu_win.iconphoto(True, tk.PhotoImage(file="files/pyv2d_icon.png"))
else:
    menu_win.iconbitmap("files/pyv2d.ico")
menu_win.title("PyV2D Menu")
menu_win.geometry("320x480+" + str(config["menu_window"]["rootx"]) + "+" + str(config["menu_window"]["rooty"]))
menu_win.resizable(0, 0)
menu_win.configure(bg="#222222")

if is_linux:
    button_font = tk.font.Font(size=10)
    mes_font = button_font
else:
    button_font = tk.font.Font(family="Yu Gothic", size=11)
    mes_font = tk.font.Font(family="Yu Gothic", size=10)
mes_label = tk.Label(menu_win, text="", font=mes_font, bg="#222222", justify="left")
mes_label.place(x=5, y=5)

if is_linux:
    menu_font = tk.font.Font(size=12)
else:
    menu_font = tk.font.Font(family="Yu Gothic", size=12)

button_1 = tk.Button(menu_win, text="アバターウインドウを開く", font=button_font, command=open_main_window, bg="#444444", fg="#ffffff", relief="flat", highlightbackground="#444444", width=30)
button_1.place(x=160, y=75, anchor=tk.CENTER)

menu_label_1 = tk.Label(menu_win, text="口を動かす基準音量", font=menu_font, fg="#ffffff", bg="#222222")
menu_label_1.place(x=10, y=110)

input_1 = tk.Entry(menu_win, font=menu_font, bg="#222222", fg="#ffffff", relief="flat", highlightbackground="#666666", width=5, justify=tk.RIGHT)
input_1.insert(tk.END, str(config["volume_threshold"]))
input_1.place(x=10, y=140)

menu_label_2 = tk.Label(menu_win, text="%", font=menu_font, fg="#ffffff", bg="#222222")
menu_label_2.place(x=70, y=140)

button_2 = tk.Button(menu_win, text="OK", font=button_font, command=update_volume_threshold, bg="#444444", fg="#ffffff", relief="flat", highlightbackground="#444444")
button_2.place(x=100, y=140)

menu_label_3 = tk.Label(menu_win, text="背景色", font=menu_font, fg="#ffffff", bg="#222222")
menu_label_3.place(x=10, y=180)

button_3 = tk.Button(menu_win, text="緑", font=button_font, command=lambda: set_bgcolor("#00ff00", "緑"), bg="#00ff00", fg="#222222", relief="flat", highlightbackground="#00ff00")
button_3.place(x=10, y=210)
button_4 = tk.Button(menu_win, text="青", font=button_font, command=lambda: set_bgcolor("#0000ff", "青"), bg="#0000ff", fg="#ffffff", relief="flat", highlightbackground="#0000ff")
button_4.place(x=60, y=210)
button_5 = tk.Button(menu_win, text="マゼンタ", font=button_font, command=lambda: set_bgcolor("#ff00ff", "マゼンタ"), bg="#ff00ff", fg="#222222", relief="flat", highlightbackground="#ff00ff")
button_5.place(x=110, y=210)
button_6 = tk.Button(menu_win, text="白", font=button_font, command=lambda: set_bgcolor("#ffffff", "白"), bg="#ffffff", fg="#222222", relief="flat", highlightbackground="#ffffff")
button_6.place(x=200, y=210)
button_7 = tk.Button(menu_win, text="黒", font=button_font, command=lambda: set_bgcolor("#000000", "黒"), bg="#000000", fg="#ffffff", relief="flat", highlightbackground="#000000")
button_7.place(x=250, y=210)

menu_label_4 = tk.Label(menu_win, text="使用するアバターデータ", font=menu_font, fg="#ffffff", bg="#222222")
menu_label_4.place(x=10, y=260)

avatar_dir_label = tk.Label(menu_win, text=config["avatar_dir"], font=button_font, bg="#222222", fg="#cccccc", justify="left")
avatar_dir_label.place(x=5, y=290)

button_8 = tk.Button(menu_win, text="アバター変更", font=button_font, command=change_avatar_dir, bg="#444444", fg="#ffffff", relief="flat", highlightbackground="#444444")
button_8.place(x=200, y=320)

menu_win.protocol("WM_DELETE_WINDOW", menu_window_close)

main_window_opened = False
if is_linux:
    show_message("この環境ではショートカットキーは使用できません")
    open_main_window(False)
else:
    open_main_window()

if not load_ok:
    show_message(error_mes, True)


#メニューウインドウが完全に表示されたあとで実行される処理
def on_load ():
    global rootx_correction
    global rooty_correction
    
    rootx_correction = menu_win.winfo_rootx() - config["menu_window"]["rootx"]
    rooty_correction = menu_win.winfo_rooty() - config["menu_window"]["rooty"]


menu_win.after(100, on_load)

if is_linux:    
    menu_win.mainloop(False)
else:
    menu_win.mainloop()


#終了処理
json_fp = open("files/config.json", "w", encoding="utf-8")
json.dump(config, json_fp, ensure_ascii=False, indent=4)
