#!/usr/bin/env python3
# coding: utf-8


#
# LICENSE
#
#  このソフトウェアは、無権利創作宣言に基づき著作権放棄されています。
#  営利・非営利を問わず、自由にご利用いただくことが可能です。
#
#   https://www.2pd.jp/license/
#


import tkinter as tk
from tkinter import font
from tkinter import filedialog
from tkinter import messagebox
import os
import subprocess
import platform
import json


APP_VERSION = "24.05-1"


app_dir = os.path.dirname(os.path.abspath(__file__))
os.chdir(app_dir)

if platform.system() == "Windows":
    is_windows = True
else:
    is_windows = False

default_dir = os.path.dirname(app_dir)

try:
    with open("config.json", "r", encoding="utf-8") as json_fp:
        config = json.load(json_fp)
except:
    config = {
        "picture_file_path" : None,
        "sound_file_path" : None,
        "video_output_path" : None
    }


def open_main_window ():
    global config
    global is_windows
    global main_win
    global label_picture_file_path
    global label_sound_file_path
    global button_convert_to_video
    
    main_win = tk.Tk()
    
    main_win.title("静止画と音声から動画を生成 v" + APP_VERSION)
    main_win.geometry("480x320")
    main_win.resizable(0, 0)
    main_win.configure(bg="#444444")
    
    main_win.protocol("WM_DELETE_WINDOW", close_main_window)
    
    if is_windows:
        main_win.iconbitmap("files/icon.ico")
        
        label_font = tk.font.Font(family="Yu Gothic", size=12)
        button_font = tk.font.Font(family="Yu Gothic", size=11)
    else:
        main_win.iconphoto(True, tk.PhotoImage(file="files/icon.png"))
        
        label_font = tk.font.Font(size=12)
        button_font = tk.font.Font(size=10)
    
    label_heading_picture_file_path = tk.Label(main_win, text="画像ファイル:", font=label_font, fg="#cccccc", bg="#444444")
    label_heading_picture_file_path.place(x=10, y=10)
    
    label_picture_file_path = tk.Label(main_win, text="(デフォルト画像を使用します)", font=label_font, fg="#ffffff", bg="#444444")
    label_picture_file_path.place(x=20, y=35)
    
    button_picture_file_path = tk.Button(main_win, text="画像を選択", font=button_font, command=change_picture_file_path, bg="#666666", fg="#ffffff", relief=tk.FLAT, highlightbackground="#666666")
    button_picture_file_path.place(x=250, y=70, width=120, height=35)
    
    button_clear_picture_file_path = tk.Button(main_win, text="取り消し", font=button_font, command=clear_picture_file_path, bg="#666666", fg="#ffffff", relief=tk.FLAT, highlightbackground="#666666")
    button_clear_picture_file_path.place(x=380, y=70, width=90, height=35)
    
    label_heading_sound_file_path = tk.Label(main_win, text="音声ファイル:", font=label_font, fg="#cccccc", bg="#444444")
    label_heading_sound_file_path.place(x=10, y=130)
    
    label_sound_file_path = tk.Label(main_win, text="(ファイルが選択されていません)", font=label_font, fg="#ffffff", bg="#444444")
    label_sound_file_path.place(x=20, y=155)
    
    button_sound_file_path = tk.Button(main_win, text="音声を選択", font=button_font, command=change_sound_file_path, bg="#666666", fg="#ffffff", relief=tk.FLAT, highlightbackground="#666666")
    button_sound_file_path.place(x=350, y=190, width=120, height=35)
    
    button_convert_to_video = tk.Button(main_win, text="動画の生成", font=button_font, command=convert_to_video, bg="#666666", fg="#ffffff", relief=tk.FLAT, highlightbackground="#666666")
    button_convert_to_video.place(x=160, y=270, width=160, height=35)
    
    change_picture_file_path(False)
    change_sound_file_path(False)
    
    main_win.mainloop()


def close_main_window ():
    global config
    global main_win
    
    with open("config.json", "w", encoding="utf-8") as json_fp:
        json.dump(config, json_fp, ensure_ascii=False, indent=4)
    
    main_win.destroy()


def change_picture_file_path (ask_filename=True):
    global config
    global default_dir
    global label_picture_file_path
    
    if config["picture_file_path"] != None:
        initial_dir = os.path.dirname(config["picture_file_path"])
    else:
        initial_dir = default_dir
    
    if ask_filename:
        file_path = filedialog.askopenfilename(title="画像ファイルを選択してください", filetypes=[("画像ファイル",".webp .png .jpeg .gif")], initialdir=initial_dir)
        
        if len(file_path) >= 1:
            config["picture_file_path"] = file_path
        else:
            return
    elif config["picture_file_path"] == None:
        return
    
    label_picture_file_path["text"] = os.path.basename(config["picture_file_path"])


def clear_picture_file_path ():
    global config
    global label_picture_file_path
    
    config["picture_file_path"] = None
    
    label_picture_file_path["text"] = "(デフォルト画像を使用します)"


def change_sound_file_path (ask_filename=True):
    global config
    global default_dir
    global label_sound_file_path
    
    if config["sound_file_path"] != None:
        initial_dir = os.path.dirname(config["sound_file_path"])
    else:
        initial_dir = default_dir
    
    if ask_filename:
        file_path = filedialog.askopenfilename(title="音声ファイルを選択してください", filetypes=[("音声ファイル",".mp3 .wav .wma .aif .flac")], initialdir=initial_dir)
        
        if len(file_path) >= 1:
            config["sound_file_path"] = file_path
        else:
            return
    elif config["sound_file_path"] == None:
        return
    
    label_sound_file_path["text"] = os.path.basename(config["sound_file_path"])


def convert_to_video ():
    global config
    global app_dir
    global default_dir
    global button_convert_to_video
    
    if config["picture_file_path"] != None:
        picture_file_path = config["picture_file_path"]
    else:
        picture_file_path = app_dir + "/files/sound_and_picture_only.webp"
        
    if config["sound_file_path"] == None:
        messagebox.showerror("エラー", "音声ファイルが選択されていません")
        return
    
    if config["video_output_path"] != None:
        initial_dir = os.path.dirname(config["video_output_path"])
        initial_file = os.path.basename(config["video_output_path"])
    else:
        initial_dir = default_dir
        initial_file = "動画.mp4"
    
    button_convert_to_video["state"] = "disable"
    button_convert_to_video["text"] = "処理中です..."
    
    file_path = filedialog.asksaveasfilename(title="動画ファイルの保存先を選択してください", filetypes=[("MP4 動画ファイル",".mp4")], initialdir=initial_dir, initialfile=initial_file, defaultextension="mp4")
    
    if len(file_path) >= 1:
        
        config["video_output_path"] = file_path
        
        subprocess.run("ffmpeg -y -loop 1 -i \"" + picture_file_path + "\" -i \"" + config["sound_file_path"] + "\" -pix_fmt yuv420p -shortest \"" + file_path + "\"", shell=True)
        
        messagebox.showinfo("動画の生成", "処理が完了しました")
    
    button_convert_to_video["state"] = "normal"
    button_convert_to_video["text"] = "動画の生成"


open_main_window()
